<?php
require_once "../Api.php";
require "./get/getServer.php";
require "./put/updateServer.php";
require "./post/createServer.php";
require "./patch/changeServer.php";
require "./delete/deleteServer.php";

class serverApi extends Api
{
   public $apiName = "server";

   /**
    * Метод GET
    * Вывод списка всех записей
    * http://ДОМЕН/Server
    * @return string
    */
   public function getAction()
   {
      $path = getParams();
      if (isset($path)) {
         $key = $path[0];
         $id = count($path) == 2 ? (int) $path[1] : null;
         switch ($key) {
            case "server":
               return getServer();
               break;
            case "basic":
               return getServerBasic();
               break;
            case "servers":
               return getServers();
               break;
            case "discovery":
               return getDiscovery();
               break;
            case "export":
               return exportServer();
               break;
            default:
               break;
         }
      } else {
         header("HTTP/1.1 400 Bad Request");
         die();
      }
   }

   /**
    * Метод POST
    * Создание новой записи
    * http://ДОМЕН/Server
    * @return string
    */
   public function createAction()
   {
      /*  $path = getParams();
        if (isset($path)) {
            $key = $path[0];
            $id = count($path) == 2 ? $path[1] : null;
            switch ($key) {
                case 'channels':
                    firstConnection($id);
                    break;
                default:
                    break;
            }
        } else {
            header('HTTP/1.1 400 Bad Request');
            die();
        } */
   }

   /**
    * Метод PATCH
    * Создание новой записи
    * http://ДОМЕН/Server
    * @return string
    */
   public function changeAction()
   {
      $path = getParams();
      if (isset($path)) {
         $key = $path[0];
         $id = count($path) == 2 ? (int) $path[1] : null;
         switch ($key) {
            case "import-server":
               saveImportServer();
               break;
            case "import-excel-server":
               saveImportExcelServer();
               break;
            default:
               break;
         }
      } else {
         header("HTTP/1.1 400 Bad Request");
         die();
      }
   }

   /**
    * Метод PUT
    * Обновление отдельной записи (по ее id)
    * http://ДОМЕН/Server
    * @return string
    */
   public function updateAction()
   {
      /*  $path = getParams();
        if (isset($path)) {
            $key = $path[0];
            $id = count($path) == 2 ? $path[1] : null;
            switch ($key) {
                case 'channels':
                    newConnection($id);
                    break;
                default:
                    break;
            }
        } else {
            header('HTTP/1.1 400 Bad Request');
            die();
        } */
   }

   /**
    * Метод DELETE
    * Удаление отдельной записи (по ее id)
    * http://ДОМЕН/Server
    * @return string
    */
   public function deleteAction()
   {
      $path = getParams();
      if (isset($path)) {
         $key = $path[0];
         // $id = count($path) == 2 ? $path[1] : null;
         switch ($key) {
            case "discovery":
               clearDiscovery();
               break;
            default:
               break;
         }
      } else {
         header("HTTP/1.1 400 Bad Request");
         die();
      }
   }
}
